/*
 * @(#)CEREntitySet.java  1.0  2006-03-20
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.model;

import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import java.beans.*;
import javax.swing.event.*;
import java.util.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
/**
 * Represents an EntitySet element in a Conceptual Entity-Relationship Model.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 2006-03-20 Created.
 */
public class CEREntitySet extends AbstractElement implements DOMStorable {
    private String name;
    public final static int TYPE_STRONG = 0;
    public final static int TYPE_WEAK = 1;
    
    private int type = TYPE_STRONG;
    
    /** Creates a new instance. */
    public CEREntitySet() {
        final ResourceBundleUtil labels = ConceptualERModel.labels;
        name = labels.getString("entitySetDefaultName");
    }
    
    public void setName(String newValue) {
        String oldValue = name;
        name = newValue;
        firePropertyChange("name", oldValue, newValue);
    }
    public String getName() {
        return name;
    }
    public void setType(int newValue) {
        int oldValue = type;
        type = newValue;
        firePropertyChange("type", oldValue, newValue);
    }
    public int getType() {
        return type;
    }
    
    /**
     * Returns connections with RelationshipSets.
     * Note: This returns two connections for self relationships!
     */
    public List<CERConnection> getCERConnections() {
        LinkedList<CERConnection> relationships = new LinkedList<CERConnection>();
        for (SimulatedRelationship c : getRelationships(ConceptualERModel.RELATIONSHIP)) {
            relationships.add((CERConnection) c);
        }
        return relationships;
    }
    
    /**
     * Returns EntitySets which are connected via a Relationship to this
     * CEREntitySet.
     */
    public List<CEREntitySet> getRelatedEntities() {
        LinkedList<CEREntitySet> list = new LinkedList<CEREntitySet>();
        for (SimulatedRelationship c : getRelationships(ConceptualERModel.RELATIONSHIP)) {
            for (SimulatedRelationship cc : c.getConnected(this).getRelationships(ConceptualERModel.ENTITY_SET)) {
                if (cc != c) {
                    list.add((CEREntitySet) cc.getConnected(c.getConnected(this)));
                }
            }
        }
        return list;
    }
    /**
     * Returns EntitySets which are connected via any kind of connection
     * to this CEREntitySet.
     */
    public List<CEREntitySet> getConnectedEntities() {
        LinkedList<CEREntitySet> list = new LinkedList<CEREntitySet>();
        for (SimulatedElement c : getRelatedElements(ConceptualERModel.ENTITY_SET)) {
            list.add((CEREntitySet) c);
        }
        return list;
    }
    /**
     * Returns linked attributes.
     */
    public List<CERAttribute> getAttributes() {
        LinkedList<CERAttribute> list = new LinkedList<CERAttribute>();
        for (SimulatedElement c : getRelatedElements(ConceptualERModel.ATTRIBUTE)) {
            list.add((CERAttribute) c);
        }
        return list;
    }
    
    protected CERAttribute createAttribute() {
        return new CERAttribute();
    }
    public int getSimulatedConcept() {
        return ConceptualERModel.ENTITY_SET;
    }
    
    public CEREntitySet clone() {
        CEREntitySet that = (CEREntitySet) super.clone();
        
        return that;
    }
    
    public void write(DOMOutput out) {
        out.addAttribute("name", name);
        out.addAttribute("type", type);
    }
    public void read(DOMInput in) {
        name = in.getAttribute("name", "Entity");
        type = in.getAttribute("type", TYPE_STRONG);
    }
    public ConceptualERModel getERModel() {
        return (ConceptualERModel) getSimulation();
    }
    public boolean isEquivalent(SimulatedObject o) {
        if (super.isEquivalent(o) && (o instanceof CEREntitySet)) {
            CEREntitySet that = (CEREntitySet) o;
            
            if (that.getType() == this.getType()) {
                return true;
            }
        }
        return false;
    }
}
